import { Link, useLocation } from 'react-router-dom'
import { Briefcase } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <>
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Briefcase size={40} strokeWidth={2.5} className="logo-icon" />
              <span className="logo-text">CareerConsult</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои сессии
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Назначить консультацию
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout

